$(document).ready(function() {

    // Scrollbar;
    $('.left-menu').niceScroll({
        cursorcolor: "#ddd",
        cursorwidth: "10px",
    });

    // navbar;
    $('.navbar-toggler').on('click', function() {
        $('.left-menu').toggleClass('active');
    })


    $('.main-content ul.folder').find('li').prepend('<span class="mr-2">&#128193;</span>');
    $('.right').find('li').prepend('<span class="mr-2"><i class="fas fa-chevron-right"></i></span>');
    // $('.left-menu-item').find('a').prepend('<i class="fas fa-circle"></i>');

    // $('.left-menu-item').on('click', function() {
    //     $(this).sibling('.left-menu-title').addClass('lalala');
    // })
    

        // Handler object;
        const MENU_INFO = {
            navLink: $('a[href^="#"]'),
            activeClassName: 'active',
            scrollTime: 500,
            offsetTop: 70,
        }
    
        // Smooth Scroll;
        MENU_INFO.navLink.click(function(e) {
            e.preventDefault();
            $('html, body').animate({
                scrollTop: $(this.hash).offset().top - (MENU_INFO.offsetTop - 20), 
            }, MENU_INFO.scrollTime);
        });
    
        // Active link when scrolling;
        function activeNavLink() {
            let scrollFromTop = $(this).scrollTop();
            $('.left-menu a[href^="#"]').each(function(e) {
                if($(this.hash).offset()) {
                    let sectionOffset = $(this.hash).offset().top;
                    if(sectionOffset <= scrollFromTop + MENU_INFO.offsetTop) {
                        $(this).parent().addClass(MENU_INFO.activeClassName);
                        $(this).parent().siblings().removeClass(MENU_INFO.activeClassName);
                    } 
                }
            });
        } activeNavLink();

        
        $(window).scroll(function() {
            activeNavLink(); 
        });

});



$(window).scroll(function() {
    console.log($(window).scrollTop());

    if($(window).scrollTop() + $(window).height() == $(document).height()) {
        // alert("bottom!");
    }
 });

// Js Start For Image Zoom

function showImagePopup(src) {
    var popup = document.createElement("div");
    popup.classList.add("popup");
    var image = document.createElement("img");
    image.classList.add("popup-image");
    image.src = src;
    popup.appendChild(image);
    document.body.appendChild(popup);
    document.body.style.overflow = "hidden";
    var zoomLevel = 1;
    var mouseDown = false;
    var startX, startY;
    var currentX, currentY;
    popup.onmousedown = function(event) {
    event.preventDefault();
    mouseDown = true;
    startX = event.clientX;
    startY = event.clientY;
    }
    popup.onmouseup = function(event) {
    event.preventDefault();
    mouseDown = false;
    }
    popup.onmousemove = function(event) {
    event.preventDefault();
    if (mouseDown) {
    currentX = event.clientX;
    currentY = event.clientY;
    var deltaX = currentX - startX;
    var deltaY = currentY - startY;
    image.style.transform = "scale(" + zoomLevel + ") translate(" + deltaX + "px, " + deltaY + "px)";
    }
    }
    popup.onclick = function() {
    document.body.removeChild(popup);
    document.body.style.overflow = "auto";
    }
    image.ondblclick = function() {
    if (zoomLevel == 1) {
    zoomLevel = 2;
    image.style.transform = "scale(2)";
    } else {
    zoomLevel = 1;
    image.style.transform = "scale(1)";
    }
    };
  
    image.addEventListener('click', function(event) {
      event.stopPropagation();
      if (zoomLevel == 1) {
        zoomLevel = 2;
        image.style.transform = "scale(2)";
      } else {
        zoomLevel = 1;
        image.style.transform = "scale(1)";
      }
    });
    
    image.addEventListener('wheel', function(event) {
      event.preventDefault();
      var delta = event.deltaY;
      if (delta < 0) {
        zoomLevel += 0.1;
      } else {
        zoomLevel -= 0.1;
      }
      if (zoomLevel < 1) {
        zoomLevel = 1;
      }
      image.style.transform = "scale(" + zoomLevel + ")";
    });
  
  }
  
  // Js End For Image Zoom

