@extends('backend.master')

@section('title')
    {{ $title }}
@endsection
@section('content')
    <x-container title="{{ $title }}"
                 :breadcrumbs="[['title' => 'Advertisement', 'route' => route('advertisements.index')], ['title' => 'Add New']]">
        <div class="card ot-card">
            <div class="card-body">
                <form action="{{ route('backend.appointment.update', $appointment->id) }}" class="row" method="post">
                    @csrf
                    @method('PUT')
                    <x-forms.input
                        :required="true"
                        label="Name"
                        name="name"
                        value="{{ $appointment->name }}"
                    ></x-forms.input>

                    <x-forms.input
                        :required="true"
                        label="Email"
                        name="email"
                        value="{{ $appointment->email }}"
                    ></x-forms.input>

                    <x-forms.input
                        :required="true"
                        label="Phone"
                        name="phone"
                        value="{{ $appointment->phone }}"
                    ></x-forms.input>

                    <x-forms.input
                        :required="true"
                        label="Property Address"
                        name="property_address"
                        value="{{ $appointment->property_address }}"
                    ></x-forms.input>

                    <x-forms.select
                        :required="true"
                        label="Property Type"
                        name="property_type">
                        <option {{ $appointment->property_type == 'letting' ? 'selected' : '' }} value="letting">{{ _trans('common.Letting') }}</option>
                        <option {{ $appointment->property_type == 'sales' ? 'selected' : '' }} value="sales">{{ _trans('common.Sales') }}
                    </x-forms.select>

                    <x-forms.input
                        col="col-lg-3 mb-3"
                        type="date"
                        label="Date"
                        name="date"
                        value="{{ $appointment->date }}"
                    ></x-forms.input>

                    <x-forms.input
                        col="col-lg-3 mb-3"
                        type="time"
                        label="Time"
                        name="time"
                        value="{{ $appointment->time }}"
                    ></x-forms.input>

                    <x-forms.textarea
                        label="Message"
                        name="message"
                        value="{{ $appointment->message }}"
                    ></x-forms.textarea>
                    <x-button></x-button>
                </form>
            </div>
        </div>
    </x-container>
@endsection


@push('script')

@endpush
