@extends('backend.master')
@section('title')
    {{ $title }}
@endsection
@section('content')
    <x-container title="{{ $title }}" :breadcrumbs="[['title' => 'Settings'],['title' => $title]]">
        <div class="table-content table-basic mt-20">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">{{ _trans('common.SMS Settings') }}</h4>
                </div>
                <div class="card-body ot-card">
                    <div class="row">
                        <div class="col-lg-7">
                            <form action="{{ route('settings.sms-setting') }}" method="Post" class="row">
                                @csrf
                                <x-forms.input name="twilio_sid" value="{{ setting('twilio_sid') }}" label="Twilio Account SID" col="col-lg-12 mb-3"></x-forms.input>
                                <x-forms.input name="auth_token" value="{{ setting('auth_token') }}" label="Authentication Token" col="col-lg-12 mb-3"></x-forms.input>
                                <x-forms.input name="registered_phone" value="{{ setting('registered_phone') }}" label="Registered Phone Number" col="col-lg-12 mb-3"></x-forms.input>
                                <x-button></x-button>
                            </form>
                        </div>

                        <div class="col-lg-5 text-center">
                            <a href="https://www.twilio.com/en-us?v=t">
                                <img src="https://demo.smart-school.in/backend/images/twilio.png?1703679969" alt="">
                                <p>https://www.twilio.com/en-us?v=t</p>
                            </a>

                            <br><br><br><br>
                            <a href="{{ route('message-sender') }}" class="btn btn-info">{{ _trans('landlord.Send SMS') }}</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </x-container>
@endsection
