<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;

//use App\Http\Controllers\Api\TenantController;
use App\Http\Controllers\Api\ReportsController;
use App\Http\Controllers\Api\CategoryController;
use App\Http\Controllers\Api\DocumentController;
use App\Http\Controllers\Api\LocationController;
use App\Http\Controllers\Api\v1\DashboardController;
use App\Http\Controllers\Api\v1\TenantController;
use App\Http\Controllers\Api\v1\PropertyController;
use App\Http\Controllers\Api\v1\RentalController;
use App\Http\Controllers\Api\v1\CommitteeController;
use App\Http\Controllers\Api\v1\CommitteeMemberController;
use App\Http\Controllers\Api\v1\AccountController;
use App\Http\Controllers\Api\v1\AccountCategoryController;
use App\Http\Controllers\Api\v1\OrderController;
use App\Http\Controllers\Api\NotificationController;

//use App\Http\Controllers\Backend\PropertyController;
use App\Http\Controllers\Api\CashManagementController;
use App\Http\Controllers\Api\Property\PropertyApiController;
use App\Http\Controllers\Api\Property\TransactionController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
 */

// Public API Routes
Route::prefix('public')->group(function () {
    Route::prefix('v1')->group(function () {
        Route::any('notLogined', [AuthController::class, 'notLogined'])->name('notLogined');
        Route::post('/register', [AuthController::class, 'register']);
        Route::post('/login', [AuthController::class, 'login']);

        Route::get('email/send/otp', [AuthController::class, 'requestOtp']);
        Route::post('email/verified/otp', [AuthController::class, 'verifyOtp']);
        Route::post('email/forgot-password', [AuthController::class, 'forgetPassword']);
        Route::post('email/reset-password', [AuthController::class, 'resetPassword']);

        Route::get('countries', [LocationController::class, 'getCountries']);
        Route::post('states', [LocationController::class, 'getStates']);
        Route::post('cities', [LocationController::class, 'getCities']);
    });
});


// Private API Routes
Route::prefix('private')->middleware('auth:sanctum')->group(function () {
    Route::prefix('v1')->group(function () {
        Route::prefix('user')->group(function () {
            Route::get('/profile', [AuthController::class, 'user']);
            Route::post('/profile-update', [AuthController::class, 'profileUpdate']);
            Route::post('/change-password', [AuthController::class, 'changePassword']);
        });

        Route::prefix('tenant')->group(function () {
            Route::controller(TenantController::class)->group(function () {
                Route::get('/dashboard', 'dashboard');
                Route::get('/orders', 'orders'); // Purchase history
                Route::get('/order-details/{id}', 'orderDetails'); // Purchase history
                Route::get('/wishlist', 'wishlist');
                Route::get('/due-payment', 'duePayment');
            });
        });

        Route::get('/dashboard', [DashboardController::class, 'landlordDashboard']);

        // Landlord API Route
        Route::controller(CommitteeController::class)->prefix('committee')->group(function (){
            Route::get('/list', 'index');
            Route::get('/create', 'create');
            Route::post('/store', 'store');
            Route::get('/edit/{id}', 'edit');
            Route::get('/show/{id}', 'show');
            Route::put('/update/{id}', 'update');
            Route::delete('/delete/{id}', 'destroy');
        });

        Route::controller(CommitteeMemberController::class)->prefix('committee-member')->group(function (){
            Route::get('/list', 'index');
            Route::get('/create', 'create');
            Route::post('/store', 'store');
            Route::put('/update/{id}', 'update');
            Route::delete('/delete/{id}', 'destroy');
        });

        Route::controller(AccountCategoryController::class)->prefix('account-category')->group(function (){
            Route::get('/list', 'index');
            Route::get('/create', 'create');
            Route::post('/store', 'store');
            Route::post('/update/{id}', 'update');
            Route::delete('/delete/{id}', 'destroy');
        });

        Route::controller(AccountController::class)->prefix('accounts')->group(function (){
            Route::get('/list', 'index');
            Route::get('/create', 'create');
            Route::post('/store', 'store');
            Route::post('/update/{id}', 'update');
            Route::delete('/delete/{id}', 'destroy');
        });

        Route::controller(TenantController::class)->prefix('tenant')->group(function () {
            Route::get('/list', 'index');
            Route::get('/create', 'create');
            Route::post('/store', 'store');
            Route::get('/edit/{id}', 'edit');
            Route::get('/show/{id}', 'show');
            Route::post('/update/{id}', 'update');
        });

        Route::controller(RentalController::class)->prefix('rental')->group(function () {
            Route::get('/list', 'index');
        });

        Route::controller(OrderController::class)->prefix('order')->group(function () {
            Route::get('/list', 'index');
            Route::get('/details/{id}', 'orderDetails');
        });

        Route::controller(PropertyController::class)->prefix('property')->group(function () {
            Route::get('/list',     'index');
            Route::get('/create',   'create');
            Route::post('/store',   'store');
            Route::put('/update/{id}',   'update');
            Route::post('/delete',   'delete');
            Route::get('/info-list', 'infoList');
            Route::get('/{id}/details-list', 'detailsList');
            Route::get('/{id}/details/{type}', 'details');
            // Property Gallery
            Route::post('/add-gallery',  'addGallery');
            Route::delete('/delete-gallery/{id}',  'deleteGallery');
            // Property Facility
            Route::post('/add-facility',  'addFacility');
            Route::put('/update-facility/{id}',  'updateFacility');
            Route::delete('/delete-facility/{id}',  'deleteFacility');
            // Floor Plan
            Route::post('/add-floorplan',  'addFloorplan');
            Route::delete('/delete-floorplan/{id}',  'deleteFloorplan');
            // Document
            Route::post('/add-document',  'addDocument');
            Route::delete('/delete-document/{id}',  'deleteDocument');
            Route::put('/update-basic-info/{id}',  'updateBasicInfo');
        });

        Route::get('category-properties', [PropertyController::class,'categoryWiseProperties']);
        Route::get('properties', [PropertyController::class,'properties']);
        Route::get('property-search-field', [PropertyController::class,'propertySearchField']);
        Route::get('property-details/{slug}', [PropertyController::class,'propertyDetails']);


        Route::controller(PropertyController::class)->prefix('wishlists')->group(function (){
            Route::post('add', 'wishlistAdd');
            Route::delete('delete/{id}', 'wishlistDelete');
        });


        Route::controller(TransactionController::class)->prefix('transactions')->group(function (){
            Route::get('landlord-transactions', 'landlordTransactionHistory');
            Route::delete('delete/{id}', 'wishlistDelete');
        });

    });
});


Route::any('notLogined', [AuthController::class, 'notLogined'])->name('notLogined');
Route::post('/register', [AuthController::class, 'register']);
Route::post('/login', [AuthController::class, 'login']);


Route::get('email/send/otp', [AuthController::class, 'requestOtp']);
Route::post('email/verified/otp', [AuthController::class, 'verifyOtp']);

Route::post('email/forgot-password', [AuthController::class, 'forgetPassword']);
Route::post('email/reset-password', [AuthController::class, 'resetPassword']);

Route::middleware('auth:sanctum')->group(function () {

    Route::post('/profile-update', [AuthController::class, 'profileUpdate']);

    Route::get('/user', [AuthController::class, 'user']);

    // Route::post('/profile-update', [AuthController::class, 'profileUpdate']);
    Route::post('/change-password', [AuthController::class, 'changePassword']);

    Route::group(['prefix' => 'property'], function () {
        Route::get('/list', [PropertyApiController::class, 'index'])->name('properties.list');
        Route::get('/create', [PropertyApiController::class, 'create'])->name('properties.create');
        Route::get('/info-list', [PropertyApiController::class, 'infoList'])->name('tenants.infoList');
        Route::get('{id}/details-list', [PropertyApiController::class, 'detailsList'])->name('properties.index');
        Route::get('{id}/details/{type}', [PropertyApiController::class, 'details'])->name('properties.api.index'); //api/property/1/details/basic
        // store
        Route::post('/store', [PropertyApiController::class, 'store'])->name('properties.store');

        // edit
        Route::get('/edit/{id}/basicinfo', [PropertyApiController::class, 'edit'])->name('properties.edit');
        // property update
        Route::post('/update/{id}/basicinfo', [PropertyApiController::class, 'update'])->name('properties.update');

        // gallery add
        Route::post('/gallery-floorplan/store', [PropertyApiController::class, 'galleryFloorplanStore'])->name('properties.galleryFloorplan.store');

        // facility edit
        Route::get('/facility/edit/{id}', [PropertyApiController::class, 'facilityEdit'])->name('properties.facility.edit');
        // facility update
        Route::post('/facility/update/{id}', [PropertyApiController::class, 'facilityUpdate'])->name('properties.facility.update');

    });

    Route::prefix('tenant')->controller(\App\Http\Controllers\Api\TenantController::class)->group(function () {
        Route::get('/', 'index')->name('tenants.index');
        Route::post('/store', 'store')->name('tenants.store');
        Route::get('/create', 'create')->name('tenants.create');
        Route::get('{id}/details-list', 'detailsList')->name('tenants.index');

        // edit
        Route::get('/edit/{id}/{slug}', 'edit')->name('tenants.edit');
        // tenant update
        Route::post('/update/{id}/{slug}', 'update')->name('tenants.update');
        Route::post('/delete/{id}/{slug}', 'delete')->name('tenants.delete');

        Route::get('/info-list', 'infoList')->name('tenants.infoList');
        Route::get('{id}/details/{type}', 'details')->name('tenants.index'); //api/property/1/details/basic
    });

    Route::group(['prefix' => 'dashboard'], function () {
        Route::get('/', [DashboardController::class, 'index'])->name('tenants.index');
        Route::get('{id}/details/{type}', [PropertyController::class, 'details'])->name('tenants.index'); //api/property/1/details/basic

    });

    Route::group(['prefix' => 'transaction'], function () {
        Route::get('/', [TransactionController::class, 'index'])->name('transaction.index');
        Route::get('/{id}/list', [TransactionController::class, 'list'])->name('transaction.list');
        Route::post('/store', [TransactionController::class, 'store'])->name('transaction.store');
        Route::get('/create', [TransactionController::class, 'create'])->name('transaction.create');
        Route::get('/details/{id}', [TransactionController::class, 'details'])->name('transaction.details');
    });

    Route::group(['prefix' => 'notifications'], function () {
        Route::get('/', [NotificationController::class, 'index'])->name('notifications.index');

    });

    Route::group(['prefix' => 'documents'], function () {
        Route::any('/', [DocumentController::class, 'index'])->name('documents.index');
        Route::any('/assets', [DocumentController::class, 'assets'])->name('documents.assets');
        Route::post('/store', [DocumentController::class, 'store'])->name('documents.store');

    });
    Route::group(['prefix' => 'cash-management'], function () {
        Route::get('/list', [CashManagementController::class, 'list'])->name('cashManagement.list');

    });

    Route::group(['prefix' => 'categories'], function () {
        Route::get('/', [CategoryController::class, 'list'])->name('categories.list');

    });
    Route::group(['prefix' => 'reports'], function () {
        Route::get('/properties', [ReportsController::class, 'properties'])->name('reports.properties');
        Route::get('/property-wise-tenants/{id}', [ReportsController::class, 'propertyWiseTenants'])->name('reports.propertyWiseTenants');
        Route::post('/search', [ReportsController::class, 'search'])->name('reports.search');

    });


    // Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    //     return $request->user();
    // });

    // locations

    Route::get('countries', [LocationController::class, 'getCountries']);
    Route::post('divisions', [LocationController::class, 'getDivision']);
    Route::post('districts', [LocationController::class, 'getdistricts']);
    // Route::post('area', [LocationController::class, 'getArea']);

    // Route::get('cities', [LocationController::class, 'getCities']);
});
